
$xmlManifest = '';	# 'content.opf'
$xmlSpine    = '';	# 'content.opf'
$xmlNav      = '';	# 'nav.xhtml'
$xmlToc      = '';	# 'toc.ncx'
$xmlTocNum   = 1;


### GET TITLE FROM HTML

	sub getHtmlTitle {

		my $htmlPath  = shift;
		my $title     = '';
		my $lineText  = '';
	
		open  FILE_HTML, "$htmlPath";
		
		while( <FILE_HTML> ) {
			$lineText  = $_;
			if ( $lineText =~ /<title>(.*?)<\/title>/ ) {
				$title = $1;
				break;
			}
		}
		
		close EPUB_FILE;
		
		return( $title );
	}


### PICK UP FILES

	sub pickFiles {

		my $srcDir  = shift;
		my $dstDir  = shift;
		my $dstRoot = shift;
		my @list = ();
	
		# GET LIST
		opendir( DIR, $srcDir ) or die("Can not open directory:$srcDir ($!)");
		@list = readdir( DIR );
		closedir( DIR );
		
		# PROCESS LIST
		foreach my $file ( sort @list ) {

			if ( $file =~ /^\./ ) { next; } # START PERIOD

			print "$srcDir/$file\n";

			# IS DIRECTORY
			if ( -d "$srcDir/$file" ){
				mkdir $dstRoot.$dstDir.'/'.$file;
				if ( $dstDir eq '' ) { pickFiles( "$srcDir/$file", "$file/",        $dstRoot ); }
				else                 { pickFiles( "$srcDir/$file", "$dstDir$file/", $dstRoot ); }
			}
			# IS FILE
			else {
				if (
					( $file =~ /\.jpg$/   )||( $file =~ /\.jpeg$/  )||
					( $file =~ /\.png$/   )||
					( $file =~ /\.gif$/   )||
					( $file =~ /\.mp3$/   )||
					( $file =~ /\.mp4$/   )||( $file =~ /\.m4v$/  )||
					( $file =~ /\.htm$/   )||
					( $file =~ /\.html$/  )||
					( $file =~ /\.xhtml$/ )||
					( $file =~ /\.css$/   )
				) {

					my $filePath;
					if ( $dstDir eq '' ) { $filePath = $file; }
					else                 { $filePath = "$dstDir$file"; }

					my $dstFile = $filePath;
					$dstFile =~ s/\.htm$/\.xhtml/;
					$dstFile =~ s/\.html$/\.xhtml/;

					my $fileId   = $dstFile;
					$fileId =~ s/\//\./g;		# / -> .
					
					if (( $file =~ /\.htm$/  )||( $file =~ /\.html$/ )) { 

						$fileType = 'application/xhtml+xml';  

						$xmlSpine .= '		<itemref idref="'.$fileId.'" linear="yes" />'."\n";
						$xmlNav   .= '				<li><a href="'.$dstFile.'">'.&getHtmlTitle( "$srcDir/$file" ).'</a></li>'."\n";

						$xmlToc   .= '		<navPoint id="'.$fileId.'" playOrder="'.$xmlTocNum.'">'."\n";
						$xmlToc   .= '			<navLabel><text>'.$filePath.'</text></navLabel>'."\n";
						$xmlToc   .= '			<content src="'.$dstFile.'" />'."\n";
						$xmlToc   .= '		</navPoint>'."\n";
						$xmlTocNum++;

					}
					elsif ( $file =~ /\.xhtml$/ ) {
						$fileType = 'application/xhtml+xml';  
						$xmlSpine .= '		<itemref idref="'.$fileId.'" linear="yes" />'."\n";
						$xmlNav   .= '				<li><a href="'.$filePath.'">'.$filePath.'</a></li>'."\n";
					}
					elsif (( $file =~ /\.jpg$/   )||( $file =~ /\.jpeg$/  )) { $fileType = 'image/jpeg'; }
					elsif  ( $file =~ /\.png$/   )                           { $fileType = 'image/png';  }
					elsif  ( $file =~ /\.gif$/   )                           { $fileType = 'image/gif';  }
					elsif  ( $file =~ /\.mp3$/   )                           { $fileType = 'audio/mp3';  }
					elsif (( $file =~ /\.mp4$/   )||( $file =~ /\.mp4$/   )) { $fileType = 'video/mp4';  }
					elsif  ( $file =~ /\.css$/   )                           { $fileType = 'text/css';   }

					$xmlManifest .= '		<item id="'.$fileId.'" href="'.$dstFile.'" media-type="'.$fileType.'" />'."\n";

					system( "cp \"$srcDir/$file\" \"$dstRoot$dstFile\"" );

				}
			}

		}

	}



### MAIN PART ###

my $gSrcDir = shift @ARGV;
my $gDstDir = $gSrcDir.'_ePub';

# CREATE DIRECTORY

mkdir $gDstDir;
mkdir $gDstDir.'/OEBPS';
mkdir $gDstDir.'/META-INF';

pickFiles( $gSrcDir, '', $gDstDir.'/OEBPS/' );


# READ INFO FILE '_info.txt'

my $ePub_FileName  = 'myBook';
my $ePub_BookName  = 'myBook';
my $ePub_Writer    = 'myName';
my $ePub_Publisher = 'myPublisher';
my $ePub_Uuid      = 'com.myPub.01-01-01-01.0000000001';
my $ePub_TocTitle  = 'CONTENTS';
my $ePub_CoverImg  = 'cover.jpg';
my $ePub_ModTime   = '2012-11-21T09:00:00Z';
my $ePub_Language  = 'en';
my $ePub_PageDir   = 'LEFT_TO_RIGHT';

open  EPUB_FILE, "$gSrcDir/_info.txt";

	while( <EPUB_FILE> ) {
		$lineText  = $_;
		$lineText  =~ s/(\r|\n)//g;   # REMOVE CR LF
		$lineText =~ /^(.+?):(.+?)$/;
		$infoKey = $1;
		$infoVal = $2;
		if    ( $infoKey eq 'EPUB_NAME'      ) { $ePub_FileName  = $infoVal; }
		elsif ( $infoKey eq 'BOOK_NAME'      ) { $ePub_BookName  = $infoVal; }
		elsif ( $infoKey eq 'WRITER_NAME'    ) { $ePub_Writer    = $infoVal; }
		elsif ( $infoKey eq 'PUBLISHER_NAME' ) { $ePub_Publisher = $infoVal; }
		elsif ( $infoKey eq 'UUID'           ) { $ePub_Uuid      = $infoVal; }
		elsif ( $infoKey eq 'TOC_TITLE'      ) { $ePub_TocTitle  = $infoVal; }
		elsif ( $infoKey eq 'COVER_IMAGE'    ) { $ePub_CoverImg  = $infoVal; }
		elsif ( $infoKey eq 'MOD_TIME'       ) { $ePub_ModTime   = $infoVal; }
		elsif ( $infoKey eq 'LANGUAGE'       ) { $ePub_Language  = $infoVal; }
		elsif ( $infoKey eq 'PAGE_DIR'       ) { $ePub_PageDir   = $infoVal; }
		elsif ( $infoKey eq 'LINE_DIR'       ) { $ePub_LineDir   = $infoVal; }
	}

close EPUB_FILE;


# CREATE 'mimetype'

open  EPUB_FILE, ">$gDstDir/mimetype";
print EPUB_FILE 'application/epub+zip';
close EPUB_FILE;


# CREATE 'META-INF/container.xml'

open  EPUB_FILE, ">$gDstDir/META-INF/container.xml";
print EPUB_FILE '<?xml version="1.0" encoding="UTF-8"?>'."\n";
print EPUB_FILE '<container version="1.0" xmlns="urn:oasis:names:tc:opendocument:xmlns:container">'."\n";
print EPUB_FILE '	<rootfiles>'."\n";
print EPUB_FILE '		<rootfile full-path="OEBPS/content.opf" media-type="application/oebps-package+xml" />'."\n";
print EPUB_FILE '	</rootfiles>'."\n";
print EPUB_FILE '</container>'."\n";
close EPUB_FILE;


# CREATE 'OEBPS/content.opf'

open  EPUB_FILE, ">$gDstDir/OEBPS/content.opf";
print EPUB_FILE '<?xml version="1.0" encoding="utf-8"?>'."\n";
print EPUB_FILE '<package version="3.0" xmlns="http://www.idpf.org/2007/opf" prefix="rendition: http://www.idpf.org/vocab/rendition/#" unique-identifier="BookID" xml:lang="'.$ePub_Language.'">'."\n";
print EPUB_FILE "\n";
print EPUB_FILE '	<metadata xmlns:dc="http://purl.org/dc/elements/1.1/">'."\n";
print EPUB_FILE '		<dc:title id="title0">'.$ePub_BookName.'</dc:title>'."\n";
print EPUB_FILE '		<dc:creator id="creator0">'.$ePub_Writer.'</dc:creator>'."\n";
print EPUB_FILE '		<dc:publisher id="publisher0">'.$ePub_Publisher.'</dc:publisher>'."\n";
print EPUB_FILE '		<dc:identifier id="BookID">urn:'.$ePub_Uuid.'</dc:identifier>'."\n";
print EPUB_FILE '		<meta property="dcterms:modified">$ePub_ModTime</meta>'."\n";
print EPUB_FILE '		<meta refines="#BookID" property="identifier-type">uuid</meta>'."\n";
print EPUB_FILE '		<dc:language id="language0">'.$ePub_Language.'</dc:language>'."\n";
print EPUB_FILE '		<meta name="cover" content="cover.jpg" />'."\n";
#print EPUB_FILE '		<meta name="primary-writing-mode" content="vertical-rl"/>'."\n";
print EPUB_FILE '	</metadata>'."\n";
print EPUB_FILE "\n";
print EPUB_FILE '	<manifest>'."\n";
print EPUB_FILE '		<item id="nav"         href="nav.xhtml"   media-type="application/xhtml+xml" properties="nav" />'."\n";
print EPUB_FILE '		<item id="cover.img"   href="'.$ePub_coverImg.'" media-type="image/jpeg" properties="cover-image" />'."\n";
print EPUB_FILE '		<item id="ncx"         href="toc.ncx"     media-type="application/x-dtbncx+xml" />'."\n";
print EPUB_FILE 		$xmlManifest;
print EPUB_FILE '	</manifest>'."\n";
print EPUB_FILE "\n";
if ( $ePub_PageDir eq 'LEFT_TO_RIGHT' ) { print EPUB_FILE '	<spine page-progression-direction="ltr" toc="ncx">'."\n"; }
else                                    { print EPUB_FILE '	<spine page-progression-direction="rtl" toc="ncx">'."\n"; }
#print EPUB_FILE '		<itemref idref="cover.xhtml" linear="no" />'."\n";
print EPUB_FILE '		<itemref idref="nav"         linear="no" />'."\n";
print EPUB_FILE 		$xmlSpine;
print EPUB_FILE '	</spine>'."\n";
print EPUB_FILE "\n";
print EPUB_FILE '	<guide>'."\n";
#print EPUB_FILE '		<reference type="cover" title="Cover Page"        href="cover.xhtml" />'."\n";
print EPUB_FILE '		<reference type="toc"   title="Table of Contents" href="nav.xhtml"   />'."\n";
print EPUB_FILE '	</guide>'."\n";
print EPUB_FILE "\n";
print EPUB_FILE '</package>'."\n";
close EPUB_FILE;


# CREATE 'OEBPS/toc.ncx'

open  EPUB_FILE, ">$gDstDir/OEBPS/toc.ncx";
print EPUB_FILE '<?xml version="1.0" encoding="utf-8"?>'."\n";
print EPUB_FILE '<ncx xmlns="http://www.daisy.org/z3986/2005/ncx/" version="2005-1">'."\n";
print EPUB_FILE '	<head>'."\n";
print EPUB_FILE '		<meta name="dtb:uid" content="'.$ePub_Uuid.'"/>'."\n";
print EPUB_FILE '		<meta name="dtb:depth" content="1"/>'."\n";
print EPUB_FILE '		<meta name="dtb:totalPageCount" content="1"/>'."\n";
print EPUB_FILE '		<meta name="dtb:maxPageNumber" content="1"/>'."\n";
print EPUB_FILE '	</head>'."\n";
print EPUB_FILE '	<docTitle><text>_TITLE_</text></docTitle>'."\n";
print EPUB_FILE '	<navMap>'."\n";
print EPUB_FILE "\n";
print EPUB_FILE $xmlToc;
print EPUB_FILE "\n";
print EPUB_FILE '	</navMap>'."\n";
print EPUB_FILE '</ncx>'."\n";
close EPUB_FILE;


# CREATE 'OEBPS/nav.xhtml'

open  EPUB_FILE, ">$gDstDir/OEBPS/nav.xhtml";
print EPUB_FILE '<?xml version="1.0" encoding="utf-8"?>'."\n";
print EPUB_FILE '<!DOCTYPE html >'."\n";
print EPUB_FILE '<html xmlns="http://www.w3.org/1999/xhtml" xmlns:epub="http://www.idpf.org/2007/ops" xml:lang="'.$ePub_Language.'" lang="'.$ePub_Language.'">'."\n";
print EPUB_FILE '<head>'."\n";
print EPUB_FILE '	<title>目次</title>'."\n";
print EPUB_FILE '</head>'."\n";
print EPUB_FILE '<body>'."\n";
print EPUB_FILE '	<nav epub:type="toc" id="nav">'."\n";
print EPUB_FILE '		<h1 class="nav"><span class="note">'.$ePub_TocTitle.'</span></h1>'."\n";
print EPUB_FILE '		<ol>'."\n";
print EPUB_FILE $xmlNav;
print EPUB_FILE '		</ol>'."\n";
print EPUB_FILE '	</nav>'."\n";
print EPUB_FILE '</body>'."\n";
print EPUB_FILE '</html>'."\n";
close EPUB_FILE;


# CREATE 'OEBPS/cover.xhtml'

open  EPUB_FILE, ">$gDstDir/OEBPS/cover.xhtml";
print EPUB_FILE '<?xml version="1.0" encoding="utf-8"?>'."\n";
print EPUB_FILE '<!DOCTYPE html>'."\n";
print EPUB_FILE '<html xmlns="http://www.w3.org/1999/xhtml" xml:lang="'.$ePub_Language.'" lang="'.$ePub_Language.'">'."\n";
print EPUB_FILE '<head>'."\n";
print EPUB_FILE '	<title>'.$ePub_BookName.'</title>'."\n";
print EPUB_FILE '</head>'."\n";
print EPUB_FILE '<body style="text-align:center;">'."\n";
print EPUB_FILE '	<div><img src="cover.jpg" /></div>'."\n";
print EPUB_FILE '</body>'."\n";
print EPUB_FILE '</html>'."\n";
close EPUB_FILE;


# ZIP

print "--- ZIP : $gDstDir ---\n";
$epubFile = $ePub_FileName.'.epub';
chdir $gDstDir;
system( "zip -0 -X ../$epubFile      mimetype" );
system( "zip -r    ../$epubFile * -x mimetype" );
chdir '..';


